s         I   @  y  &                                     PTRSeries                       Power Ten R-Series DC Power Supplies                                                                    ViInt16     ViInt32    ViReal64      ViRsrc     	 	ViBoolean     	 	ViSession      ViStatus       ViChar[]      ViChar      ViString     	  ViInt16[]     	  ViInt32[]     
  	ViReal64[]      	 
ViBoolean[]     
 
ViConstString      This instrument module provides programming support for the Power Ten R-Series Power Supplies.  The module is divided into the following functions:

Functions/Classes:

(1) Initialize:
This function initializes the instrument and sets it to a default configuration.

(2) Application Functions: (Class)
This class contains high-level, test and measurement routines.  These examples call other instrument driver functions to configure, start, and read from the instrument.

(3) Configuration Functions: (Class)
This class of functions configures the instrument by setting acquisition and system configuration parameters.

(4) Action/Status Functions: (Class)
This class of functions begins or terminates an acquisition. It also provides functions which allow the user to determine the current status of the instrument.

(5) Utility Functions: (Class)
This class of functions provides lower level functions to communicate with the instrument, and change instrument parameters.

(7) Close:
This function takes the instrument offline.
         This class contains high-level, test and measurement routines.  These examples call other instrument driver functions to configure, start, and read from the instrument.

     q    This class of functions configures the instrument by setting acquisition and system configuration parameters.

         This class of functions begins or terminates an acquisition. It also provides functions which allow the user to determine the current status of the instrument.

     ;    This class of functions provides lower level functions.

    .    Power Ten R60 & R80 Power Supplies with an Remote Programming Interface option can support up to thirty additional S60 & S80 Power Supplies from a single GPIB Address or RS232 Serial Port. In the following Power Ten Driver Routines the ChannelName refers to the S Series Slave Address. Valid Slave Addresses are two through thirty-one. Slave address zero is reserved for Group Trigger and address one is reserved for the Master chassis.

This function performs the following initialization actions:

- Opens a session to the Default Resource Manager resource and a session to the specified device using the interface and address specified in the Resource_Name control.

- Performs an identification query on the Instrument.

- Resets the instrument to a known state and clears all error and status information.

- Returns an Instrument Handle which is used to differentiate between different sessions of this instrument driver.

- Each time this function is invoked a Unique Session is opened.  It is possible to have more than one session open for the same resource.
        This control specifies the interface and address of the device that is to be initialized (Instrument Descriptor). The exact grammar to be used in this control is shown in the note below. 

Notes:

(1) Based on the Instrument Descriptor, this operation establishes a communication session with a device.  The grammar for the Instrument Descriptor is shown below.  Optional parameters are shown in square brackets ([]).

Interface   Grammar
------------------------------------------------------
GPIB        GPIB[board]::primary address[::secondary address]
            [::INSTR]

RS232       ASRL<port>::INSTR

Examples: "GPIB::1::INSTR", "ASRL2::INSTR"

        This control specifies if an ID Query is sent to the instrument during the initialization procedure.

Valid Range:
VI_OFF (0) - Skip Query
VI_ON  (1) - Do Query (Default Value)

Notes:
   
(1) Under normal circumstances the ID Query ensures that the instrument initialized is the type supported by this driver. However circumstances may arise where it is undesirable to send an ID Query to the instrument.  In those cases; set this control to "Skip Query" and this function will initialize the selected interface, without doing an ID Query.
    D    This control specifies if the instrument is to be reset to its power-on settings during the initialization procedure.

Valid Range:
VI_OFF (0) - Don't Reset
VI_ON  (1) - Reset Device (Default Value)

Notes:

(1) If you do not want the instrument reset. Set this control to "Don't Reset" while initializing the instrument.
    7    This control returns an Instrument Handle that is used in all subsequent function calls to differentiate between different sessions of this instrument driver.

Notes:

(1) Each time this function is invoked a Unique Session is opened.  It is possible to have more than one session open for the same resource.
         This control contains the status code returned by the function call. See Error_Message function for descriptions of returned error codes. 

    a ?         Resource Name                      ;        ID Query                            ;        Reset Device                      l     }    Instrument Handle                        Status                                Yes VI_ON No VI_OFF   Yes VI_ON No VI_OFF    	           	               This function configures and initiates the power supply to generate a DC voltage on the channel you specify. 

SCPI: SOURCE[]:VOLTAGE <voltage value>         The ViSession Handle that you obtain from the Initialize function.  The handle identifies a particular instrument session.

Default Value:  None
         This control contains the status code returned by the function call. See Error_Message function for descriptions of returned error codes. 
     K    Pass the name of the channel you want to configure. Valid range is 1-31.
     x    Pass the DC voltage you want the power supply to generate.
Units: volts

Valid Range: dependent upon the model in use
    3          Instrument Handle                         Status                            c 3 
       Channel Name                       3        Voltage                                	           "1"    0.0        This function configures and initiates the power supply to generate a DC current on the channel you specify.

SCPI: SOURCE[]:CURRENT <current value>         The ViSession Handle that you obtain from the Initialize function.  The handle identifies a particular instrument session.

Default Value:  None
         This control contains the status code returned by the function call. See Error_Message function for descriptions of returned error codes. 
     6    Pass the name of the channel you want to configure.
     x    Pass the DC voltage you want the power supply to generate.
Units: volts

Valid Range: dependent upon the model in use
              Instrument Handle                 a        Status                             3 
       Channel Name                      4 3        Current                                	           "1"    0.0   ]    This function configures and initiates the power supply to generate a DC voltage ramp starting from the present output voltage and ending at the specified voltage in the specified time on the specified channel. Time range is from 100ms to 99sec. with 100ms resolution. Time is in seconds.

SCPI: SOURCE[]:VOLTAGE:RAMP <ending voltage value> <time>         The ViSession Handle that you obtain from the Initialize function.  The handle identifies a particular instrument session.

Default Value:  None
         This control contains the status code returned by the function call. See Error_Message function for descriptions of returned error codes. 
     7    Pass the name of the channel you want to configure.

     w    Pass the DC voltage you want the power supply to generate.
Units: volts
Valid Range: dependent upon the model in use
     -    Ramp time in seconds.
Valid range 0.1 - 99.              Instrument Handle                         Status                            ; 3 
       Channel Name                      z 3        Voltage                            3       Time                                   	           "1"    0.0    0.0   ]    This function configures and initiates the power supply to generate a DC current ramp starting from the present output current and ending at the specified current in the specified time on the specified channel. Time range is from 100ms to 99sec. with 100ms resolution. Time is in seconds.

SCPI: SOURCE[]:CURRENT:RAMP <ending voltage value> <time>         The ViSession Handle that you obtain from the Initialize function.  The handle identifies a particular instrument session.

Default Value:  None
         This control contains the status code returned by the function call. See Error_Message function for descriptions of returned error codes. 
     6    Pass the name of the channel you want to configure.
     x    Pass the DC voltage you want the power supply to generate.
Units: amps

Valid Range: dependent upon the model in use

     .    Ramp time in seconds.
Range is 0.1 - 99 sec.    "          Instrument Handle                 #\        Status                            # 3 
       Channel Name                      $/ 3        Current                           $ 3       Time                                   	           "1"    0.0    0.0        This function sets the output state to On (1) or Off (0). If set to OFF the Voltage and Current values will be set to zero. If set to ON the Voltage and Current will be set to their last programmed values.     7    Pass the name of the channel you want to configure.

         The ViSession Handle that you obtain from the Initialize function.  The handle identifies a particular instrument session.

Default Value:  None
         This control contains the status code returned by the function call. See Error_Message function for descriptions of returned error codes. 
    & b 6       Channel Name                      ')  4        Instrument Handle                 '       Status                           aL        State                              "1"        	            On 1 Off 0    o    This function takes a voltage measurement of the output on the channel you specify.

SCPI: MEASURE[]:VOLTAGE?     +    Returns the measured value.

Units: volts         The ViSession Handle that you obtain from the Initialize function.  The handle identifies a particular instrument session.

Default Value:  None
         This control contains the status code returned by the function call. See Error_Message function for descriptions of returned error codes. 
     5    Pass the name of the channel you want to measure.

    ) 3        Voltage Measurement               )  	        Instrument Handle                 *        Status                            +, 3 
       Channel Name                       	               	           "1"    o    This function takes a current measurement of the output on the channel you specify.

SCPI: MEASURE[]:CURRENT?     /    Returns the measured value.

Units:  amperes
         The ViSession Handle that you obtain from the Initialize function.  The handle identifies a particular instrument session.

Default Value:  None
         This control contains the status code returned by the function call. See Error_Message function for descriptions of returned error codes. 
     5    Pass the name of the channel you want to measure.

    , 3        Current Measurement               -  	        Instrument Handle                 -        Status                            .> 3 
       Channel Name                       	               	           "1"        This function returns the operationing mode of the power supply. The two modes of operation are constant voltage (mode = 0) and constant current (mode = 1). See Protection Condition Status Register for more information.         The ViSession Handle that you obtain from the Initialize function.  The handle identifies a particular instrument session.

Default Value:  None
         This control contains the status code returned by the function call. See Error_Message function for descriptions of returned error codes. 
    0W  /        Instrument Handle                \ *       Channel Name                      0 H      status                           [C       Mode                               0    "1"    	            	               The power supply has two modes of operation: constant current and constant voltage. This function configures the power supply to shut down if the power supply switches from constant voltage mode to constant current mode. If Service Request is set ON (1) the Protection Event Status reporting mechanism will be turned on and a GPIB Service Request will be generated upon this action.         The ViSession Handle that you obtain from the Initialize function.  The handle identifies a particular instrument session.

Default Value:  None
         This control contains the status code returned by the function call. See Error_Message function for descriptions of returned error codes. 
    4  /        Instrument Handle                \ *       Channel Name                      4 H      status                           Sy        Service Request                    0    "1"    	            On 1 Off 0       The power supply has two modes of operation, constant current and constant voltage. This function configures the power supply to shut down if the power supply switches from constant current mode to constant voltage mode. If Service Request is set ON (1) the Protection Event Status reporting mechanism will be turned on and a GPIB Service Request will be generated upon this action.         The ViSession Handle that you obtain from the Initialize function.  The handle identifies a particular instrument session.

Default Value:  None
         This control contains the status code returned by the function call. See Error_Message function for descriptions of returned error codes. 
    7  /        Instrument Handle                \ *       Channel Name                      8T H      status                           Tx        Service Request                    0    "1"    	            On 1 Off 0        The power supply has two modes of operation, constant current and constant voltage. This function configures the power supply to operate in both modes. All Protection Event Status reporting mechanisms will be turned off.         The ViSession Handle that you obtain from the Initialize function.  The handle identifies a particular instrument session.

Default Value:  None
         This control contains the status code returned by the function call. See Error_Message function for descriptions of returned error codes. 
   W -       Channel Name                      :  2        Instrument Handle                 ;d K      status                             "1"    0    	            a    This routine turns on/off the external user connector isolation relay on the specified channel.     7    Pass the name of the channel you want to configure.

         The ViSession Handle that you obtain from the Initialize function.  The handle identifies a particular instrument session.

Default Value:  None
         This control contains the status code returned by the function call. See Error_Message function for descriptions of returned error codes. 
    = f        Channel Name                      =X          Instrument Handle                 =       Status                           ^7        State                              "1"        	           On 1 Off 0    a    This routine turns on/off the external user connector isolation relay on the specified channel.     7    Pass the name of the channel you want to configure.

         The ViSession Handle that you obtain from the Initialize function.  The handle identifies a particular instrument session.

Default Value:  None
         This control contains the status code returned by the function call. See Error_Message function for descriptions of returned error codes. 
    ? N C       Channel Name                     Fc        State                             @)  >        Instrument Handle                 @ 2      Status                             "1"    On 1 Off 0        	               This function configures the power supply to generate a triggered DC voltage on the channel you specify. A software trigger must be used to initiate this sequence.

SCPI: SOURCE[]:VOLTAGE:TRIG <voltage value>         The ViSession Handle that you obtain from the Initialize function.  The handle identifies a particular instrument session.

Default Value:  None
         This control contains the status code returned by the function call. See Error_Message function for descriptions of returned error codes. 
     7    Pass the name of the channel you want to configure.

     w    Pass the DC voltage you want the power supply to generate.
Units: volts
Valid Range: dependent upon the model in use
    C,          Instrument Handle                 C        Status                            D\ 3 
       Channel Name                      D 3        Voltage                                	           "1"    0.0        This function configures the power supply to generate a triggered DC current on the channel you specify. A software trigger must be used to initiate this sequence.

SCPI: SOURCE[]:CURRENT:TRIG <current value>         The ViSession Handle that you obtain from the Initialize function.  The handle identifies a particular instrument session.

Default Value:  None
         This control contains the status code returned by the function call. See Error_Message function for descriptions of returned error codes. 
     7    Pass the name of the channel you want to configure.

     w    Pass the DC voltage you want the power supply to generate.
Units: volts
Valid Range: dependent upon the model in use
    F          Instrument Handle                 G        Status                            H 3 
       Channel Name                      HU 3        Current                                	           "1"    0.0   K    This function configures the power supply to generate a triggered DC voltage ramp starting at the present output voltage and ending at the specified voltage in the specified time on the specified channel. Time is in seconds. See Send Software Trigger for more information.

SCPI: SOURCE[]:VOLTAGE:RAMP:TRIG <voltage value> <time>         The ViSession Handle that you obtain from the Initialize function.  The handle identifies a particular instrument session.

Default Value:  None
         This control contains the status code returned by the function call. See Error_Message function for descriptions of returned error codes. 
     6    Pass the name of the channel you want to configure.
     w    Pass the DC voltage you want the power supply to generate.
Units: volts
Valid Range: dependent upon the model in use
     .    Ramp time in seconds.
Range is 0.1 - 99 sec.    K          Instrument Handle                 K        Status                            LI 3 
       Channel Name                      L 3        Voltage                           M 2       Time                                   	           "1"    0.0    0.0   K    This function configures the power supply to generate a triggered DC current ramp starting at the present output current and ending at the specified current in the specified time on the specified channel. Time is in seconds. See Send Software Trigger for more information.

SCPI: SOURCE[]:CURRENT:RAMP:TRIG <current value> <time>         The ViSession Handle that you obtain from the Initialize function.  The handle identifies a particular instrument session.

Default Value:  None
         This control contains the status code returned by the function call. See Error_Message function for descriptions of returned error codes. 
     6    Pass the name of the channel you want to configure.
     v    Pass the DC current you want the power supply to generate.
Units: amps
Valid Range: dependent upon the model in use
     .    Ramp time in seconds.
Range is 0.1 - 99 sec.    O          Instrument Handle                 PX        Status                            P 3 
       Channel Name                      Q+ 3        Current                           Q 2       Time                                   	           "1"    0.0    0.0        This function sets the Over Voltage Protection limit on the channel you specify. If the output of the instrument exceeds this value the instrument will shutdown and must be Reset to continue.

SCPI: SOURCE[]:VOLTAGE:PROTECTION <ovp value>
         The ViSession Handle that you obtain from the Initialize function.  The handle identifies a particular instrument session.

Default Value:  None
         This control contains the status code returned by the function call. See Error_Message function for descriptions of returned error codes. 
     7    Pass the name of the channel you want to configure.

         Pass the DC over voltage value you want the power supply shutdown at.
Units: volts
Valid Range: dependent upon the model in use

    T          Instrument Handle                 T        Status                            U6 3 
       Channel Name                      Uu 3        Overvoltage Protection                 	           "1"    0.0        This function sets the soft voltage and current programming limits for the selected channel.

SCPI: SOURCE[]:VOLTAGE:LIMIT <voltage value>
      SOURCE[]:CURRENT:LIMIT <current value>         This control contains the status code returned by the function call. See Error_Message function for descriptions of returned error codes. 
         The ViSession Handle that you obtain from the Initialize function.  The handle identifies a particular instrument session.

Default Value:  None
    W       Status                            XH          Instrument Handle                U        Channel Name                     T        Volltage Limit                   U       Current Limit                      	               "1"    0.0    0.0       This function sets the power on output values for voltage, current, and over voltage protection on the selected channel.

SCPI: CALIBRATE[]:INITIAL:VOLTAGE <voltage value>
      CALIBRATE[]:INITIAL:CURRENT <current value>
      CALIBRATE[]:INITIAL:VOLTAGE:PROTECTION <ovp value>         This control contains the status code returned by the function call. See Error_Message function for descriptions of returned error codes. 
         The ViSession Handle that you obtain from the Initialize function.  The handle identifies a particular instrument session.

Default Value:  None
    [1       Status                            [          Instrument Handle                U        Channel Name                     T        Voltage                          U       Current                                 OVP                                	               "1"    0.0    0.0    0.0        This routine configures the foldback mode for the selected channel. The three mode are: 0 = off, 1 = Constant Volatge, 2 = Constant Current. Configuring the foldback mode for Constant Voltage or Constant Current will cause the power supply to shut down if the other mode becomes active.         The ViSession Handle that you obtain from the Initialize function.  The handle identifies a particular instrument session.

Default Value:  None
         This control contains the status code returned by the function call. See Error_Message function for descriptions of returned error codes. 
   e 1       Channel Name                     bi       Mode                              ^  0        Instrument Handle                 _ h      Status                             "1"    0        	              This routine configures the number of voltage measurements to be average upon recept of a measure output voltage command.  Acceptable number is from one (1) to five (5) and the Default is one (1). No explicit time is used between measurements.

SCPI:MEASURE[]:VOLTAGE:AVERAGE <value>     0    Number of voltage measurements to be averaged.         The ViSession Handle that you obtain from the Initialize function.  The handle identifies a particular instrument session.

Default Value:  None
         This control contains the status code returned by the function call. See Error_Message function for descriptions of returned error codes. 
   e 1       Channel Name                      b8 bi       Average                           bp  0        Instrument Handle                 c h      Status                             "1"    1        	              This routine configures the number of current measurements to be average upon recept of a measure output current command.  Acceptable number is from one (1) to five (5) and the Default is one (1). No explicit time is used between measurements.

SCPI:MEASURE[]:CURRENT:AVERAGE <value>     0    Number of current measurements to be averaged.         The ViSession Handle that you obtain from the Initialize function.  The handle identifies a particular instrument session.

Default Value:  None
         This control contains the status code returned by the function call. See Error_Message function for descriptions of returned error codes. 
   e 1       Channel Name                      e bi       Average                           e  0        Instrument Handle                 f h      Status                             "1"    1        	          b    This routine configures the Protection Event Status Enable Register which causes the instrument to shut down if Constant Current, Constant Voltage, Foldback Modes or other conditions are enabled. Along with this register the Service Request Enable Register must be programmed to generate GPIB Service Requests.

SCPI: STATUS[]:PROTECTION:ENABLE <value>         The ViSession Handle that you obtain from the Initialize function.  The handle identifies a particular instrument session.

Default Value:  None
         This control contains the status code returned by the function call. See Error_Message function for descriptions of returned error codes. 
   K        Channel Name                      iw          Instrument Handle                 j N      Status                           HO        Protection Event Enable            "1"        	           0        This routine configures the Standard Event Status Enable Register. Along with this register the Service Request Enable Register must be programmed to generate GPIB Service Requests.

SCPI: *ESE[] <value>         The ViSession Handle that you obtain from the Initialize function.  The handle identifies a particular instrument session.

Default Value:  None
         This control contains the status code returned by the function call. See Error_Message function for descriptions of returned error codes. 
   K        Channel Name                      ll          Instrument Handle                 m N      Status                           HO        Standard Event Enable              "1"        	           0   n    This routine sets the Service Request Enable Register which is used to enable GPIB Service Requests when a enabled protection event or standard event has occured. This register along with the Protection Event Status Enable Register or the Standard Event Status Enable Register must be programmed to enable generation of GPIB Service Requests.

SCPI: *SRE[] <value>         The ViSession Handle that you obtain from the Initialize function.  The handle identifies a particular instrument session.

Default Value:  None
         This control contains the status code returned by the function call. See Error_Message function for descriptions of returned error codes. 
   @        Channel Name                      p          Instrument Handle                 p >      Status                           :B        Service Request Enable             "1"        	           0    g    This function returns the programmed voltage value on the channel you specify.

SCPI: SOURCE[]:VOLT?
     -    Returns the measured value.

Units:  volts
         The ViSession Handle that you obtain from the Initialize function.  The handle identifies a particular instrument session.

Default Value:  None
         This control contains the status code returned by the function call. See Error_Message function for descriptions of returned error codes. 
     5    Pass the name of the channel you want to measure.

    r 3        Programmed Voltage                r  	        Instrument Handle                 sa        Status                            s 3 
       Channel Name                       	               	           "1"    j    This function returns the programmed current value on the channel you specify.

SCPI: SOURCE[]:CURRENT?
     /    Returns the measured value.

Units:  amperes
         The ViSession Handle that you obtain from the Initialize function.  The handle identifies a particular instrument session.

Default Value:  None
         This control contains the status code returned by the function call. See Error_Message function for descriptions of returned error codes. 
     5    Pass the name of the channel you want to measure.

    u 3        Programmed Current                u  	        Instrument Handle                 vn        Status                            w 3 
       Channel Name                       	               	           "1"        This function returns the programmed overvoltage protection value on the channel you specify.

SCPI: SOURCE[]:VOLTAGE:PROTECTION?     /    Returns the programmed value.

Units:  volts
         The ViSession Handle that you obtain from the Initialize function.  The handle identifies a particular instrument session.

Default Value:  None
         This control contains the status code returned by the function call. See Error_Message function for descriptions of returned error codes. 
     4    Pass the name of the channel you want to measure.
    x 3        Programmed OVP                    x  	        Instrument Handle                 y        Status                            z) 3 
       Channel Name                       	               	           "1"    :    This function gets the output state - On (1) or Off (0).     6    Pass the name of the channel you want to configure.
         The ViSession Handle that you obtain from the Initialize function.  The handle identifies a particular instrument session.

Default Value:  None
         This control contains the status code returned by the function call. See Error_Message function for descriptions of returned error codes. 
    { b 6       Channel Name                      {  4        Instrument Handle                 |w       Status                           _       State                              "1"        	            	            C    This function gets the isolation relay state - On (1) or Off (0).     6    Pass the name of the channel you want to configure.
         The ViSession Handle that you obtain from the Initialize function.  The handle identifies a particular instrument session.

Default Value:  None
         This control contains the status code returned by the function call. See Error_Message function for descriptions of returned error codes. 
    ~N b 6       Channel Name                      ~  4        Instrument Handle                 '       Status                           _       State                              "1"        	            	            ?    This function gets the sense relay state - On (1) or Off (0).     7    Pass the name of the channel you want to configure.

         The ViSession Handle that you obtain from the Initialize function.  The handle identifies a particular instrument session.

Default Value:  None
         This control contains the status code returned by the function call. See Error_Message function for descriptions of returned error codes. 
     b 6       Channel Name                      9  4        Instrument Handle                        Status                           _       State                              "1"        	            	                This function recalls the soft voltage and current programming limits for the selected channel.

SCPI: SOURCE[]:VOLTAGE:LIMIT?
      SOURCE[]:CURRENT:LIMIT?         The ViSession Handle that you obtain from the Initialize function.  The handle identifies a particular instrument session.

Default Value:  None
         This control contains the status code returned by the function call. See Error_Message function for descriptions of returned error codes. 
     5    Pass the name of the channel you want to measure.

      	        Instrument Handle                  o      Status                            6 3 
       Channel Name                     3        Voltage Limit                    1r       Current Limit                          	           "1"    	           	               This function recalls the power on output voltage, current, and ovp values for the selected channel.

SCPI: CALIBRATE[]:INITIAL:VOLTAGE?
      CALIBRATE[]:INITIAL:CURRENT?
      CALIBRATE[]:INITIAL:VOLTAGE:PROTECTION?         The ViSession Handle that you obtain from the Initialize function.  The handle identifies a particular instrument session.

Default Value:  None
         This control contains the status code returned by the function call. See Error_Message function for descriptions of returned error codes. 
     5    Pass the name of the channel you want to measure.

              Instrument Handle                 ) o      Status                             3 
       Channel Name                     3        Voltage                          1r       Current                          r       OVP                                    	           "1"    	           	           	               This function recalls the number of voltage reading that will be averaged upon receipt of a voltage measurent command for the selected channel.

SCPI: MEASURE:VOLTAGE:AVERAGE?         The ViSession Handle that you obtain from the Initialize function.  The handle identifies a particular instrument session.

Default Value:  None
         This control contains the status code returned by the function call. See Error_Message function for descriptions of returned error codes. 
     5    Pass the name of the channel you want to measure.

     7    The number of voltage readings that will be averaged.    -          Instrument Handle                         Status                            ] 3 
       Channel Name                       3        Average                                	           "1"    	                This function recalls the number of current reading that will be averaged upon receipt of a current measurent command for the selected channel.

SCPI: MEASURE:CURRENT:AVERAGE?         The ViSession Handle that you obtain from the Initialize function.  The handle identifies a particular instrument session.

Default Value:  None
         This control contains the status code returned by the function call. See Error_Message function for descriptions of returned error codes. 
     5    Pass the name of the channel you want to measure.

     7    The number of current readings that will be averaged.              Instrument Handle                 $        Status                             3 
       Channel Name                       3        Average                                	           "1"    	           z    This function sends a software trigger to the channel you specify. Setting the channel to zero will trigger all power supplies that have been previously configured for triggered voltage and/or current outputs. The trigger types are as follows:

1 = Voltage
2 = Current
3 = Both Voltage and Current
4 = Voltage or Current Ramp

SCPI: TRIGGER[]:TYPE <value>
      TRIGGER[]:RAMP         The ViSession Handle that you obtain from the Initialize function.  The handle identifies a particular instrument session.

Default Value:  None
         This control contains the status code returned by the function call. See Error_Message function for descriptions of returned error codes. 
      8        Instrument Handle                 I <      Status                           N 8       Channel Name                     N>       Trigger Type                       0    	           "1"    1        This function clears all previously configured voltage and current triggers for the specified channel.

SCPI: TRIGGER[]:ABORT          The ViSession Handle that you obtain from the Initialize function.  The handle identifies a particular instrument session.

Default Value:  None
         This control contains the status code returned by the function call. See Error_Message function for descriptions of returned error codes. 
    W  '        Instrument Handle                         Status                           E #       Channel Name                       0    	           "1"        This function reads the status byte from the instrument and creates a string that indicates which bits are active.

SCPI: *STB[]?

     N    This control returns the error code read from the instrument's error queue.
         This control returns the error message string read from the instrument's error message queue.

Notes:

(1) The array must contain at least 256 elements ViChar[256].         This control contains the status code returned by the function call. See Error_Message function for descriptions of returned error codes. 
         The ViSession Handle that you obtain from the Initialize function.  The handle identifies a particular instrument session.

Default Value:  None
     U,        Status Byte                       !  n  ,    Status Message                     (      Status                            d  5        Instrument Handle                Y <       Channel Name                       	            	            	               "1"        This function reads the standard event status register from the instrument and creates a string that indicates which bits are active.

SCPI: *ESR[]?

     N    This control returns the error code read from the instrument's error queue.
         This control returns the error message string read from the instrument's error message queue.

Notes:

(1) The array must contain at least 256 elements ViChar[256].         This control contains the status code returned by the function call. See Error_Message function for descriptions of returned error codes. 
         The ViSession Handle that you obtain from the Initialize function.  The handle identifies a particular instrument session.

Default Value:  None
     ?Y        Standard Event Status Register    -  t  ,    Status Message                     >      Status                            p  5        Instrument Handle                = <       Channel Name                       	            	            	               "1"        This function reads the event status enable register from the instrument and creates a string that indicates which bits are active.

SCPI: *ESE[]?

         This control contains the status code returned by the function call. See Error_Message function for descriptions of returned error codes. 
         The ViSession Handle that you obtain from the Initialize function.  The handle identifies a particular instrument session.

Default Value:  None
   ?Y        Standard Event  Enable Register   t  ,    Status Message                     >      Status                            v  5        Instrument Handle                = <       Channel Name                       	            	            	               "1"        This function reads the protection event status reister from the instrument and creates a string that indicates which bits are active.

SCPI: STATUS[]:PROTECTION:EVENT?

         This control contains the status code returned by the function call. See Error_Message function for descriptions of returned error codes. 
         The ViSession Handle that you obtain from the Initialize function.  The handle identifies a particular instrument session.

Default Value:  None
   An        Protection Event Register           ,    Status Message                    g      Status                             +        Instrument Handle                > 4       Channel Name                       	            	            	               "1"        This function reads the protection event status enable register from the instrument and creates a string that indicates which bits are active.

SCPI: STATUS[]:PROTECTION:ENABLE?

         This control contains the status code returned by the function call. See Error_Message function for descriptions of returned error codes. 
         The ViSession Handle that you obtain from the Initialize function.  The handle identifies a particular instrument session.

Default Value:  None
   An        Prot. Event Enable Register         ,    Status Message                    "g      Status                             +        Instrument Handle                > 4       Channel Name                       	            	            	               "1"       This function reads the protection condition status reister from the instrument and creates a string that indicates which bits are active. Use this routine to determine the operating mode (voltage or current) of the power supply.

SCPI: STATUS[]:PROTECTION:CONDITION?

         This control contains the status code returned by the function call. See Error_Message function for descriptions of returned error codes. 
         The ViSession Handle that you obtain from the Initialize function.  The handle identifies a particular instrument session.

Default Value:  None
   An        Protection Condition Register     ~  ,    Status Message                    g      Status                            6 +        Instrument Handle                > 4       Channel Name                       	            	            	               "1"        This function reads the service request enable reister from the instrument and creates a string that indicates which bits are active.

SCPI:*SRE[]?

         This control contains the status code returned by the function call. See Error_Message function for descriptions of returned error codes. 
         The ViSession Handle that you obtain from the Initialize function.  The handle identifies a particular instrument session.

Default Value:  None
   An        Service Req. Enable Register      ~  ,    Status Message                    g      Status                            = +        Instrument Handle                > 4       Channel Name                       	            	            	               "1"        This function resets the instrument to its Power On state and clears all error and status reporting data structures on the selected channel.

SCPI: *RST[]
      *CLS[]

         This control contains the status code returned by the function call. See Error_Message function for descriptions of returned error codes. 
         The ViSession Handle that you obtain from the Initialize function.  The handle identifies a particular instrument session.

Default Value:  None
     G      Status                            X  *        Instrument Handle                E /       Channel Name                       	               "1"    n    This function clears all error and status reporting data structures on the selected channel.

SCPI: *CLS[]

         This control contains the status code returned by the function call. See Error_Message function for descriptions of returned error codes. 
         The ViSession Handle that you obtain from the Initialize function.  The handle identifies a particular instrument session.

Default Value:  None
     G      Status                              *        Instrument Handle                E /       Channel Name                       	               "1"    l    This function reads an error code and error string from the instrument's error queue.

SCPI: SYSTEM:ERROR?     N    This control returns the error code read from the instrument's error queue.
         This control returns the error message string read from the instrument's error message queue.

Notes:

(1) The array must contain at least 256 elements ViChar[256].         This control contains the status code returned by the function call. See Error_Message function for descriptions of returned error codes. 
         The ViSession Handle that you obtain from the Initialize function.  The handle identifies a particular instrument session.

Default Value:  None
    y = D   `    Error Code                         ?   ,    Error Message                     } ?      Status                              6        Instrument Handle                  	            	            	                   This function takes the Status Code returned by the instrument driver functions, interprets it and returns it as a user readable string.      t    This control accepts the Status Code returned from the instrument driver functions.

Default Value:
0 - VI_SUCCESS         This control returns the interpreted Status Code as a user readable message string.

Notes:

(1) The array must contain at least 256 elements ViChar[256].     (    Reports the status of this operation.
         The ViSession Handle that you obtain from the Initialize function.  The handle identifies a particular instrument session.

Default Value:  None
    < =    `    Status Code                        =       Message                           \
      Status                             5        Instrument Handle                  0    	            	               ~    This function returns the Manufacturer, Model, Serial Number and firmware revision numbers of the instrument.

SCPI: *IDN[]?         This control returns the Instrument Driver Software Revision.

Notes:

(1) The array must contain at least 256 elements ViChar[256].         This control contains the status code returned by the function call. See Error_Message function for descriptions of returned error codes. 
         The ViSession Handle that you obtain from the Initialize function.  The handle identifies a particular instrument session.

Default Value:  None
     =       *IDN? Respone                     0       Status                              1        Instrument Handle                < 1       Channel Name                       	            	               "1"    ^    This function returns the revision numbers of the instrument driver and instrument firmware.         This control returns the Instrument Driver Software Revision.

Notes:

(1) The array must contain at least 256 elements ViChar[256].         This control returns the Instrument Firmware Revision.

Notes:

(1) The array must contain at least 256 elements ViChar[256].         This control contains the status code returned by the function call. See Error_Message function for descriptions of returned error codes. 
         The ViSession Handle that you obtain from the Initialize function.  The handle identifies a particular instrument session.

Default Value:  None
     C/       Instrument Driver Revision        K .       Firmware Revision                  ]      Status                            g  3        Instrument Handle                B 7       Channel Name                       	            	            	               "1"        This function recalls the instrument's maximum voltage and current rating for the selected channel.

SCPI: CALIBRATE[]:MODEL:VOLTAGE?
      CALIBRATE[]:MODEL:CURRENT?         The ViSession Handle that you obtain from the Initialize function.  The handle identifies a particular instrument session.

Default Value:  None
         This control contains the status code returned by the function call. See Error_Message function for descriptions of returned error codes. 
          Pass the name of the channel.
      	        Instrument Handle                 Å o      Status                             3 
       Channel Name                     3        Model Voltage                    1r       Model Current                          	           "1"    	           	               This function performs the following operations:
viClose (instrSession) and viClose (rmSession).

Notes:

(1) The instrument must be reinitialized to use it again.     (    Reports the status of this operation.
         The ViSession handle that you obtain from the Init or InitWithOptions function.  The handle identifies a particular instrument session.

Default Value:  None
    ' pD      Status                            W r `        Instrument Handle                  	                     +  A             K.        init                                                                                                                                               6             K.        GenerateDCVolt                                                                                                                                   (               K.        GenerateDCCurr                                                                                                                                      .             .        GenerateDCVRamp                                                                                                                                  !\  $             .        GenerateDCCRamp                                                                                                                                  &  (Y             K.        OutState                                                                                                                                         )R  +i             .        MeasureDCVolt                                                                                                                                    ,`  .{             .        MeasureDCCurr                                                                                                                                    /r  1             K.        QueryMode                                                                                                                                        2  57             K.        VoltMode                                                                                                                                         61  8             K.        CurrMode                                                                                                                                         9  ;             K.        NormalMode                                                                                                                                       <  >             K.        IsolationRelay                                                                                                                                   ?  AY             K.        SenseRelay                                                                                                                                       BR  E             K.        ConfigDCVolt                                                                                                                                     F  H             K.        ConfigDCCurr                                                                                                                                     I  M<             K.        ConfigDCVRamp                                                                                                                                    Nj  Q             K.        ConfigDCCRamp                                                                                                                                    S
  V              K.        ConfigOVP                                                                                                                                        V  X             K.        ConfigSoftLimits                                                                                                                                 Z  \a             K.        ConfigPowerOn                                                                                                                                    ]  `#             K.        ConfigFoldback                                                                                                                                   a  c             K.        ConfigVoltAve                                                                                                                                    d  g             K.        ConfigCurrAve                                                                                                                                    h
  j             K.        ConfigProtEventEnable                                                                                                                            k  m             K.        ConfigStandEventEnable                                                                                                                           n  q2             K.        ConfigSerReqEnable                                                                                                                               r"  t3             .        OutputVoltQuery                                                                                                                                  u*  w@             .        OutputCurrQuery                                                                                                                                  x7  ze             .        OutputOVPQuery                                                                                                                                   {\  }             K.        OutStateQuery                                                                                                                                    ~               K.        IsoRelayQuery                                                                                                                                      i             K.        SenseRelayQuery                                                                                                                                  `  s             .        SoftLimitsQuery                                                                                                                                                 .        PowerOnQuery                                                                                                                                     t               .        measVoltAveQuery                                                                                                                                   5             .        measCurrAveQuery                                                                                                                                 ,               K.        SendSWTrigger                                                                                                                                                   K.        AbortTrigger                                                                                                                                     >               K.        StatusByteQuery                                                                                                                                  7               K.        StandEventQuery                                                                                                                                  C               K.        StandEventEnableQuery                                                                                                                            I  -             K.        ProtEventQuery                                                                                                                                   e  R             K.        ProtEventEnableQuery                                                                                                                                            K.        ProtCondQuery                                                                                                                                    	               K.        ServiceReqEnableQuery                                                                                                                                           K.        reset                                                                                                                                              O             K.        clear                                                                                                                                                           K.        errorQuery                                                                                                                                         '             K.        errorMessage                                                                                                                                       `             K.        idQuery                                                                                                                                          W               E.        revisionQuery                                                                                                                                    :  B             .        ModelQuery                                                                                                                                       z               K.        close                                                                                                                                                                                                                               Initialize                                                                          Application Functions                                                             Generate Output                                                                      Generate DC Voltage                                                                  Generate DC Current                                                                  Generate DC Voltage Ramp                                                             Generate DC Current Ramp                                                          Output State                                                                         Output State On/Off                                                               Measure Output                                                                       Measure DC Voltage                                                                   Measure DC Current                                                                Operating Mode                                                                       Query Output Mode                                                                    Constant Voltage Mode                                                                Constant Current Mode                                                                Normal Mode                                                                       External User                                                                        Isolation Relay                                                                      Sense Relay                                                                         Configuration Functions                                                              Configure DC Voltage                                                                 Configure DC Current                                                                 Configure DC Voltage Ramp                                                            Configure DC Current Ramp                                                            Configure OVP                                                                        Configure Soft Limits                                                                Configure Power On                                                                   Configure Foldback                                                                   Configure Voltage Measurement Average                                                Configure Current Measurement Average                                                Configure Protect. Event Enable                                                      Configure Standard Event Enable                                                      Configure Service Req. Enable                                                        Output Voltage Query                                                                 Output Current Query                                                                 Output OVP Query                                                                     Output State Query                                                                   Isolation Relay Query                                                                Sense Relay Query                                                                    Soft Limits Query                                                                    Power On Query                                                                       Voltage Measurement Average Query                                                    Current Measurement Average Query                                                   =Action/Status Functions                                                              Send Software Trigger                                                                Abort Trigger                                                                        Status Byte Query                                                                    Standard Event Query                                                                 Standard Event Enable Query                                                          Protection Event Query                                                               Protection Event Enable Query                                                        Protection Condition Query                                                           Sevice Req. Enable Query                                                            Utility Functions                                                                    Reset                                                                                Clear                                                                                Error Query                                                                          Error Message                                                                        Id Query                                                                             Revision Query                                                                       Model Query                                                                          Close                                                                           